package jp.mosp.common.vo;

import java.util.Properties;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;

public abstract class MosPWorkFlowVo extends MosPVo {

	private static final long serialVersionUID = -1733626895330281082L;

	// p[^
	public static final String PRM_HID_VOUCHER	 		= "hidVoucher";
	public static final String PRM_TXT_COMMENT	 		= "txtComment";

	// tB[h
	private String 		hidVoucher;
	private String 		txtComment;

	private String[][] aryComments;
	private String 		lblComment;

	// tB[hyѐ
	public static final String NAM_CHANGE_COMMENT = CommonConst.NAM_CHANGING + CommonConst.NAM_COMMENT;
	public static final String NAM_AUTHOR_COMMENT = CommonConst.NAM_APPROVER + "" + CommonConst.NAM_COMMENT;

	public static final int	LEN_COMMENT	= 20;

	/**
	 * RXgN^
	 */
	public MosPWorkFlowVo(
			Properties cfg,
			Properties msg,
			Properties nam,
			String cmd,
			CmAspUserDto aspUser,
			CmUserDto user
	) {
		super(cfg, msg, nam, cmd, aspUser, user);
		hidVoucher		= "";
		txtComment		= "";
		aryComments 	= new String[0][0];
	}

	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request) {
		hidVoucher = request.getParameter(PRM_HID_VOUCHER);
		txtComment = request.getParameter(PRM_TXT_COMMENT);
	}

	/**
	 * ߃Rgꗗ
	 * @param aryComments	Rgz
	 */
	public void setCommentFields(String[][] aryComments) {
		for (int i = 0; i < aryComments.length; i++) {
			aryComments[i][0] = escapeHTML(aryComments[i][0]);
			aryComments[i][1] = escapeHTML(aryComments[i][1]);
		}
		this.aryComments = aryComments.clone();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}

	// ANZT\bh
	public String 	getHidVoucher() 	{ return hidVoucher					; }
	public String 	getEscHidVoucher() 	{ return escapeHTML(hidVoucher)		; }

	public void 	setHidVoucher(String hidVoucher) { this.hidVoucher 	= hidVoucher; }

	public String getTxtComment() { return txtComment; }
	public String getEscTxtComment() { return escapeHTML(txtComment); }

	public void setTxtComment(String txtComment) { this.txtComment = txtComment; }

	public String[][] getEscAryComments() { return aryComments.clone(); }

	public String getEscLblComment() { return escapeHTML(lblComment); }
	public void setLblComment(String lblComment) { this.lblComment = lblComment; }

}
